--
-- CloseShopsByTime
--
-- @author  nilBrain
-- @date  	12/11/2024


CloseShopsByTime = {};


CloseShopsByTime.blockedShops = {
	{g_gui.guis.ShopMenu, string.format(g_i18n:getText("vehicleShop_isClosed"), g_i18n:getText("map_shop"))},
	{"AnimalScreen", string.format(g_i18n:getText("animalDealer_isClosed"), g_i18n:getText("animals_dealer"))}
};

function CloseShopsByTime:loadMap(mapFilename)
	if g_currentMission:getIsClient() then
		g_messageCenter:subscribe(MessageType.GUI_AFTER_OPEN, self.onGuiOpen, self);
	end;
end;

function CloseShopsByTime:deleteMap()
	if g_currentMission:getIsClient() then
		g_messageCenter:unsubscribe(MessageType.GUI_AFTER_OPEN, self);
	end;
end;

function CloseShopsByTime:onGuiOpen()
	local hr = g_currentMission.environment.currentHour;
	if hr == 12 or (hr >= g_currentMission.environment.lighting.nightStart or hr < g_currentMission.environment.lighting.nightEnd) then
		CloseShopsByTime.isShopBlocked = true;
		for _, shop in pairs(CloseShopsByTime.blockedShops) do
			local gui = g_gui.guis[shop[1]];

			if gui ~= nil and  g_gui.currentListener == gui then
				self.closeGuiOrDialog(true, {gui, shop[2]});
			elseif g_gui.currentGui == shop[1] or g_gui.currentListener == shop[1] then
				self.closeGuiOrDialog(false, shop);
			end;
		end;
	end;
end;

function CloseShopsByTime.closeGuiOrDialog(isDialog, shop)
	local l18n = "";
	if isDialog and type(shop[1]) == "string" then
		g_gui:closeDialogByName(shop[1]);
	else
		g_gui:showGui("");
	end;

	InfoDialog.show(shop[2]);
end;

addModEventListener(CloseShopsByTime);